﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=6.47
@EndOfDesignText@
#CustomBuildAction: folders ready, %WINDIR%\System32\Robocopy.exe,"..\..\Shared Files" "..\Files"
#CustomBuildAction: folders ready, %WINDIR%\System32\Robocopy.exe,"..\..\Files" "..\Files"
Sub Class_Globals
	Public X2 As X2Utils
	Private xui As XUI 'ignore
	Public world As B2World
	Public Ground As X2BodyWrapper
	Private ivForeground As B4XView
	Private ivBackground As B4XView
	Public lblStats As B4XView
	Public TileMap As X2TileMap
	Public Const ObjectLayer As String = "Object Layer 1"
	Private UserTouchesScreen As Boolean
	Private PanelForTouch As B4XView
	Private Car As X2BodyWrapper
	Private force As B2Vec2
End Sub

Public Sub Initialize (Parent As B4XView)
	Parent.LoadLayout("GameLayout")
	world.Initialize("world", world.CreateVec2(0, 0))
	X2.Initialize(Me, ivForeground, world)
	Dim WorldWidth As Float = 10 'meters
	Dim WorldHeight As Float = WorldWidth / 1.333 'same ratio as in the designer script
	X2.ConfigureDimensions(world.CreateVec2(WorldWidth / 2, WorldHeight / 2), WorldWidth)
	'comment to disable debug drawing
	'X2.EnableDebugDraw
	TileMap.Initialize(X2, File.DirAssets, "hello world with background.json", ivBackground)
	'We want the tiles to be square. Otherwise we will have issues with rotated tiles.
	Dim TileSize As Int = Min(X2.MainBC.mWidth / TileMap.TilesPerRow, X2.MainBC.mHeight / TileMap.TilesPerColumn)
	TileMap.SetSingleTileDimensionsInBCPixels(TileSize, TileSize)
	'Update the world center based on the map size
	SetWorldCenter
	TileMap.PrepareObjectsDef(ObjectLayer)
	'create the two borders
	TileMap.CreateObject2(ObjectLayer, 9)
	TileMap.CreateObject2(ObjectLayer, 10)
	'create the car
	Car = TileMap.CreateObject2ByName(ObjectLayer, "car")
	'add the circle front and connect it to the car with a WeldJoint.
	Dim front As X2BodyWrapper = TileMap.CreateObject2ByName(ObjectLayer, "car front")
	Dim weld As B2WeldJointDef
	weld.Initialize(Car.Body, front.Body, front.Body.WorldCenter)
	X2.mWorld.CreateJoint(weld)
	force = X2.CreateVec2(0, 0.5)
End Sub

Private Sub SetWorldCenter
	'The map size will not be identical to the screen size. This happens because the tile size in (bc) pixels needs to be a whole number.
	'So we need to update the world center and move the map to the center.
	X2.UpdateWorldCenter(TileMap.MapAABB.Center)
End Sub

Public Sub Resize
	X2.ImageViewResized
End Sub

Public Sub Tick (GS As X2GameStep)
	TileMap.DrawScreen(Array("Tile Layer 1"), GS.DrawingTasks)
	If UserTouchesScreen Then
		Car.Body.ApplyForceToCenter(Car.Body.Transform.MultiplyRot(force))
	End If

End Sub

Public Sub DrawingComplete
	TileMap.DrawingComplete
End Sub

'Return True to stop the game loop
Public Sub BeforeTimeStep (GS As X2GameStep) As Boolean
	Return False
End Sub


Sub PanelForTouch_Touch (Action As Int, X As Float, Y As Float)
	If Action = PanelForTouch.TOUCH_ACTION_DOWN Or Action = PanelForTouch.TOUCH_ACTION_MOVE Then
		For Each bw As X2BodyWrapper In X2.GetBodiesIntersectingWithWorldPoint(X2.ScreenPointToWorld(X, Y))
			If bw.Name = "car" Then
				'never do physcial stuff from the Touch event. Only from inside the game loop
				X2.AddFutureTask(Me, "car_touched", 0, "")
			End If
		Next
		
		UserTouchesScreen = True
	Else
		UserTouchesScreen = False
	End If
End Sub

Sub Car_Touched (ft As X2FutureTask)
	Car.Body.ApplyAngularImpulse(5)
End Sub